﻿/************************************************************************************************************
* $$FileName		Convert Related Topics To Hyperlink .jsx
*
* $$Description		This script scan all the topics and search for Related topic design time control. 
*						   It then convert each of the related topic to a hyperlink	
*
* Copyright (c) 2010 Adobe Systems Incorporated. All Rights Reserved.
*************************************************************************************************************/

//these are the constants for the tags 
var OBJECTTAGSTART = 131632;
var OBJECTTAGEND = 268567088;
var PARAMTAG		 = 131617;

//topic manager.
var topicmgr;
//snippet manager
var snippetmgr;

main();

function main()
{
	msg('Starting the conversion of converting related topics');
	topicmgr = RoboHelp.project.TopicManager;
	snippetmgr= RoboHelp.project.SnippetManager;
	ConvertAllRelatedTopics(topicmgr);
	ConvertAllRelatedTopics(snippetmgr);
	msg('Done with conversion');
}

function ConvertAllRelatedTopics(mgr)
{
	if(isValidType(mgr)&& mgr.count>0)
	{
		var topic = mgr.item(1);
		while(isValidType(topic))
		{
			ConverRelatedTopic(topic);
			topic = topic.next;
		}
	}
}

function ConverRelatedTopic(file)
{
	//first check if this file exists or not
	if(isValidType(file)&& file.valid)
	{
		msg('Parsing Topic '+file.path);
		//we will create al popup ID with name PopupID+count
		var tokenmgr = RoboHelp.getTokenManager(file.path);
		var bSave = false;
		var currentRelatedObjectTag=null;
		var bRelatedTopicObject=false;
		var hyperlinkArray=null;

		if(isValidType(tokenmgr))
		{
			if(tokenmgr.count>0)
			{
				var token = tokenmgr.item(1);
				while(isValidType(token))
				{
					//check if it is text or not
					if(token.tokenType == RoboHelp.TokenType.TOKENTAG)
					{
						if(token.tagType==OBJECTTAGSTART)		//tag type for object tag
						{
							//this is the start of object tag, 
							//initialize all the variables.
							currentRelatedObjectTag = token;
							bRelatedTopicObject=false;
							hyperlinkArray=null;
						}
						else if(currentRelatedObjectTag!=null && token.tagType==PARAMTAG)
						{
							//we need to check if the command is related topic or not
							var currentParamName = token.getAttribute('name');
							var currentParamValue = token.getAttribute('value');
							if(isValidType(currentParamName) && isValidType (currentParamValue))
							{
								
								//name is valid, check if it is command or not
								currentParamName = currentParamName.toLowerCase();
								if(currentParamName=='command')
								{
									//this is a command now check the value of this command
									currentParamValue = currentParamValue.toLowerCase();
									if(currentParamValue.indexOf('related topics')!=-1)
									{
										//this is a related topic 
										bRelatedTopicObject=true;
									}
								}
							
								//check for item1, item 2 
								if(bRelatedTopicObject && currentParamName.indexOf('item')!=-1)
								{
									//check if it is a item tag or not
									//we have the item tag, just save the value in array so that we can add that topic as hyperlink in the end
									if(hyperlinkArray==null)
									{
										hyperlinkArray=new Array();
									}
									hyperlinkArray[hyperlinkArray.length]=currentParamValue;
								}
							}
						}
						else if(bRelatedTopicObject && token.tagType == OBJECTTAGEND)
						{
							//try to find the end span tag now
							var endTag = FindEndSpanTag(token);
							var startTag = FindStartSpanTag(currentRelatedObjectTag);
							//we have reached the end of object tag, now we need to add all the hyperlinks and remove the object tag.
							//check if there is any hyperlink or not
							if(hyperlinkArray!=null && hyperlinkArray.length>0)
							{
								//add all the topic one by one
								//we start from the last one so that we have the correct sequence
								for(var index=hyperlinkArray.length-1;index>=0;index--)
								{
									AddHyperlinkInTopic(hyperlinkArray[index],token);
								}
							}
							//we need to remove the object tag now
							DeleteObjectTag(currentRelatedObjectTag,token);
							startTag.delete();
							endTag.delete();
							bSave=true;
							
							//reset the variables again
							currentRelatedObjectTag=null;
							bRelatedTopicObject=false;
							hyperlinkArray=null;
							//
						}
					}

					token = token.next;
				}
			}
		}
		else
			alert('there is some error in getting the token manager');
			
		if(bSave)
		{
			msg('saving file '+file.path);
			tokenmgr.save();
		}
	}
	else
	{
		//this file is missing skip this 
		msg('File '+file.path +" is missing ");
	}
}

function FindEndSpanTag(token)
{
	//we need to find a comment tag from here
	var retVal=token;
	while(1)
	{
		if(retVal.tagType==96)
		{
			//check if it has end span or not
			var tokenName=retVal.name;
			tokenName = tokenName.toLowerCase();
			if(tokenName.indexOf("endspan")!=-1)
			{
				break;
			}
		}
		retVal = retVal.next;
	}
	return retVal;
}

function FindStartSpanTag(token)
{
	//we need to find a comment tag from here
	var retVal=token;
	while(1)
	{
		if(retVal.tagType==96)
		{
			//check if it has start span or not
			//FF80F713-5DC6-11d0-A7B4-00AADC53E937
			var tokenName=retVal.name;
			if(tokenName.indexOf('FF80F713-5DC6-11d0-A7B4-00AADC53E937')!=-1)
			{
				//we found start of object tag
				break;
			}
		}
		retVal = retVal.previous;
	}
	return retVal;
}

function DeleteObjectTag(startTag,endTag)
{
	//we have to delete till we reach the end tag
	var currentTag = startTag;
	var nextTag = currentTag.next;
	while(nextTag!=endTag)
	{
		currentTag.delete();
		currentTag = nextTag;
		nextTag = currentTag.next;
	}
	//in the end delete the end tag
	endTag.delete();
}

function AddHyperlinkInTopic(relatedTopicValue,objectendToken)
{
	//we first need to find the topic name and then the topic URL
	//the topic name is ; seperated
	if(isValidType(relatedTopicValue) && isValidType(objectendToken))
	{
		var index = relatedTopicValue.indexOf(';');
		if(index>=0)
		{
			var topicName = relatedTopicValue.substr(0,index);
			var topicURL  = relatedTopicValue.substr(index+1);
			if(isValidType(topicName) && isValidType(topicURL))
			{
				//we need to replace all \ in URL with /
				var myPattern = new RegExp("\\\\","gi");  
				topicURL  = topicURL .replace(myPattern,'/');
				
				//this is the place where you add the anchor tag, we can customize this to add any style if required.
				
				var hyperlinkHTMLText = "<p class=\"newHyperLinkPClass\"><a class=\"newHyperLinkClass\" href=\""+topicURL+"\">"+ topicName+"</a></p>";
				objectendToken.insertText(hyperlinkHTMLText,true);	//after the object tag
			}
		}
	}
}

function isValidType(value)
{
	if(typeof(value) !== 'undefined' && value != null) 
	{
		return true;
	}
	return false;	
}
function msg(szString)
{
	RoboHelp.project.outputMessage (szString);
	RoboHelp.project.outputMessage ('\n');
}

